<?php

class AnyPay
{
    private $merchant_id;
    private $merchant_key;
    private $api_id;
    private $api_key;
    private $client;
    private $error = NULL;

    function __construct($merchant_id, $merchant_key, $api_id, $api_key)
    {
        $this->merchant_id = $merchant_id;
        $this->merchant_key = $merchant_key;
        $this->api_id = $api_id;
        $this->api_key = $api_key;
        $this->client = new \GuzzleHttp\Client();
    }

    public function getError()
    {
        return $this->error;
    }

    public function getBalance()
    {
        try {
            $res = $this->client->request('POST', 'https://anypay.io/api/balance/'.$this->api_id, [
                'form_params' => [
                    'sign' => hash('sha256', "balance{$this->api_id}{$this->api_key}")
                ]
            ]);
        }
        catch(Exception $e)
        {
            writeLog('anypay_getBalance: '.$e->getMessage());
            $this->error = $e->getMessage();
            return false;
        }
        $r = json_decode($res->getBody()->getContents(), true);
        if (isset($r['error']))
        {
            writeLog('anypay_getBalance: '.json_encode($r));
            $this->error = json_encode($r);
            return false;
        }
        return $r['result']['balance'];
    }

    public function createPayout($payout_id, $payout_type, $amount, $wallet)
    {
        try {
            $res = $this->client->request('POST', 'https://anypay.io/api/create-payout/'.$this->api_id, [
                'form_params' => [
                    'payout_id' => $payout_id,
                    'payout_type' => $payout_type,
                    'amount' => $amount,
                    'wallet' => $wallet,
                    'sign' => hash('sha256', "create-payout{$this->api_id}{$payout_id}{$payout_type}{$amount}{$wallet}{$this->api_key}")
                ]
            ]);
        }
        catch(Exception $e) {
            writeLog('anypay_createPayout: '.$e->getMessage());
            return false;
        }
        $r = json_decode($res->getBody()->getContents(), true);
        if (isset($r['error']))
        {
            writeLog('anypay_createPayout: '.json_encode($r));
            return false;
        }
        return $r['result'];
    }

    public function listPayouts()
    {
        try {
            $res = $this->client->request('POST', 'https://anypay.io/api/payouts/'.$this->api_id, [
                'form_params' => [
                    'sign' => hash('sha256', "payouts{$this->api_id}{$this->api_key}")
                ]
            ]);
        }
        catch(Exception $e) {
            writeLog('anypay_listPayouts: '.$e->getMessage());
            return false;
        }
        $r = json_decode($res->getBody()->getContents(), true);
        if (isset($r['error']))
        {
            writeLog('anypay_listPayouts: '.json_encode($r));
            return false;
        }
        return $r['result'];
    }
}

function anypay_class()
{
    require($_SERVER['DOCUMENT_ROOT'].'/config/setup.payment.php');
    return new AnyPay($setup_payment['anypay_id'], $setup_payment['anypay_secret_key'], $setup_payment['anypay_api_id'], $setup_payment['anypay_api_key']);
}