<?php

class FreeKassa
{
    private $shop_id;
    private $password_1;
    private $password_2;
    private $client;

    public function __construct($shop_id, $password_1, $password_2)
    {
        $this->shop_id = $shop_id;
        $this->password_1 = $password_1;
        $this->password_2 = $password_2;
        $this->client = new \GuzzleHttp\Client();
    }

    public function getBalance()
    {
        $data = [
            'shopId' => $this->shop_id,
            'nonce' => time(),
        ];
        ksort($data);
        $sign = hash_hmac('sha256', implode('|', $data), $this->password_1);
        $data['signature'] = $sign;
        try {
            $res = $this->client->request('POST', 'https://api.freekassa.ru/v1/balance', [
                'form_params' => $data
            ]);
        }
        catch (Exception $e) {
            global $bd;
            return $bd->escape($e->getMessage());
        }
        $r = json_decode(getBody()->getContents(), true);
        return $r['balance']['value'];
    }
}