<?php

# запускает cron задачу
#
# name: имя файла задачи
# interval: интервал между выполнениями в секундах
# или day чтобы выполнять задачу 1 раз в день в 00:00
function cron_load($name, $interval)
{
    global $bd;
    $patch = $_SERVER['DOCUMENT_ROOT'];
    $timestamps = json_decode(file_get_contents(__DIR__.'/timestamps'), true);
    $expired = false;
    if (!isset($timestamps[$name])) {
        if ($interval == 'day')
        {
            $d = new DateTime;
            $d->modify('+1 day');
            $sec_zero = strtotime($d->format('Y-m-d'));
            $timestamps[$name] = $sec_zero;
        }
        else
            $timestamps[$name] = time();
        $expired = true;
    }
    else
    {
        if ($interval == 'day')
        {
            $d = new DateTime;
            $sec_zero = strtotime($d->format('Y-m-d'));
            if ($sec_zero >= $timestamps[$name])
                $expired = true;
        }
        else
            $expired = (time() - $timestamps[$name]) > $interval;
    }
    if ($expired)
    {
        include __DIR__.'/tasks/'.$name.'.php';
        if ($interval == 'day')
        {
            $d = new DateTime;
            $d->modify('+1 day');
            $sec_zero = strtotime($d->format('Y-m-d'));
            $timestamps[$name] = $sec_zero;
        }
        else
            $timestamps[$name] = time();
        file_put_contents(__DIR__.'/timestamps', json_encode($timestamps, JSON_PRETTY_PRINT));
    }
}


# cron задачи запуск
cron_load('active_users', 300);
cron_load('auto_clear', 300);
cron_load('auto_up_tasks', 300);
cron_load('chistkatestv', 300);
cron_load('competition', 'day');
cron_load('banners', 300);
cron_load('birzabue', 300);
cron_load('birzanoactive', 300);
cron_load('bonus', 300);
cron_load('corectref', 300);
cron_load('del_t', 300);
// cron_load('del_user1', 300);
cron_load('del_user2', 300);
cron_load('del_user3', 300);
cron_load('konkurs', 300);
cron_load('moder_bonus', 300);
cron_load('scrin', 300);
cron_load('serf', 300);
cron_load('statistik', 300);
cron_load('support', 300);
cron_load('sys_mail', 300);
cron_load('work_task_wait', 300);
cron_load('work_test_wait', 300);
cron_load('work_task_auto', 300);
cron_load('work_sites_cron', 300);
cron_load('update_moder', 300);
cron_load('zadanclear', 300);
cron_load('profit', 300);
cron_load('dialogchistka', 300);
cron_load('druzavka', 300);
cron_load('grafikdelete', 300);
cron_load('kurs_usd', 300);
cron_load('refsend_cron', 300);
cron_load('sqlonline', 300);
cron_load('sqlwork', 300);
cron_load('testclear', 300);
cron_load('vkclear', 300);
cron_load('youtubeclear', 300);
// cron_load('other', 2250);
cron_load('ads_txt', 300);
cron_load('priz_for_desc', 'day');